/*
 * Perform any needed database fixup
 */
#include <unistd.h>
#include <stdio.h>

#include "db.h"
#include "libfma.h"
#include "lf_dflt_error.h"
#include "lf_fabric.h"
#include "lf_fabric_db.h"

lf_fabric_t *fp;
int do_write_xbar_links;

static void
usage()
{
  fprintf(stderr, "This brings the database up-to-date if recent version\n");
  fprintf(stderr, "changes have added or changed columns.\n");
  fprintf(stderr, "\n");
  fprintf(stderr, "Usage: fm_fixup_db\n");
  fprintf(stderr, "  -h - print this help message\n");
  fprintf(stderr, "  -R <fms_run> - specify FMS_RUN directory\n");
  fprintf(stderr, "  -N <fms_db_name> - specify database name\n");
  fprintf(stderr, "  -V - print version\n");
  exit(1);
}

int
main(
  int argc,
  char **argv)
{
  int c;
  db_database_ptr_t dbp;
  struct lf_fabric_db *fdp;
  struct lf_fabric *fp;
  extern char *optarg;
  char *db_name;
  char *fms_run;

  lf_init();

  /* defaults */
  fms_run = getenv(LF_ENV_FMS_RUN);
  if (fms_run == NULL || *fms_run == '\0') fms_run = LF_DFLT_FMS_RUN;
  db_name = getenv(LF_ENV_DB_NAME);
  if (db_name == NULL || *db_name == '\0') db_name = LF_DFLT_DB_NAME;

  /* command line args */
  while ((c = getopt(argc, argv, "hH:R:N:V")) != EOF) switch (c) {
  case 'V':
    printf("FMS version is %s\n", Lf_version);
    exit(0);
    break;
  case 'h':
    usage();
    break;
  case 'H':
    fprintf(stderr,
	"Please note: -H has been replaced with -R and is deprecated\n");
    /* FALLSTHROUGH */

  case 'R':
    fms_run = optarg;
    break;
  case 'N':
    db_name = optarg;
    break;
  default:
    usage();
  }

  dbp = db_open_database(fms_run, db_name, TRUE);
  if (dbp == NULL) LF_ERROR(("Error opening database"));

  fdp = lf_fabric_db_handle(dbp);
  if (fdp == NULL) LF_ERROR(("Error getting fabric DB handle"));

  /* open any existing fabric */
  fp = lf_load_fabric(fdp);
  if (fp == NULL) {
    LF_ERROR(("Error loading fabric database"));
  }

  printf("Database is up-to-date\n");

  exit(0);

 except:
  exit(1);
}
